function	tr_bad = vb_plot_bad_trials2(data,ix_tr,flg, varargin)
% Candidate trials for rejection are plotted for confirmation by human visual
% inspection.
%
% 2014/09/19 Okito Yamashita 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%------------------------
% Figure properties
%------------------------
PARM = finputcheck(varargin, ...
    { 
    'BACKCOLOR'         'real'   []      [0 0 0]; ...
    'CUIBUTTONCOLOR'    'real'   []    [.8 .8 .8]; ...
    'FIGSIZE'           'real'   []   get(0,'monitorpositions')*0.95;...
    'TSTEP'             'integer' []     5;....
    'label'             'integer' []     [1:size(data,3)];...
    'ylimits'            'real'   []     []});
if ischar(PARM)
    error(PARM);
end

BACKCOLOR = PARM.BACKCOLOR;
GUIBUTTONCOLOR   = PARM.CUIBUTTONCOLOR;
FIGSIZE = PARM.FIGSIZE;
TSTEP = PARM.TSTEP;
label = PARM.label;
ylimits = PARM.ylimits;
if isempty(ylimits), ylimits = [-max(abs(data(:))) max(abs(data(:)))]; end

%----------------------------
% Data of rejection channels
%----------------------------
flgsum=sum(flg(:,ix_tr),1);
[flgsumsort,jx_tr_sort]=sort(flgsum(:),1,'descend');
ix_tr_sort = ix_tr(jx_tr_sort);

y = data(:,:,ix_tr_sort);
ntr = length(ix_tr);
pannel_rej = [];

%------------------
% set up the figure
% -----------------
column =ceil(sqrt( ntr ))+1;
rows = ceil(ntr/column);

hfig = figure('name', [ 'Trial Rejection'], 'tag', 'main', ...
    'numbertitle', 'off', 'color', BACKCOLOR, 'windowstyle', 'modal', 'position', FIGSIZE);
set(hfig,'MenuBar', 'none');
incx = 120;
incy = 110;
sizewx = 100/column;
if rows > 2
    sizewy = 90/rows;
else
    sizewy = 80/rows;
end;
pos = get(gca,'position'); % plot relative to current axes
q = [pos(1) pos(2) 0 0];
s = [pos(3) pos(4) pos(3) pos(4)]./100;
axis off;

% figure rows and columns
% -----------------------
count = 1;
for tr = 1 : ntr
    % compute coordinates
    X = mod(count-1, column)/column * incx-10;
    Y = (rows-floor((count-1)/column))/rows * incy - sizewy*1.3;

    if ~strcmp(get(gcf, 'tag'), 'main');
        disp('Aborting plot');
        return;
    end;

    % Plot channel timeseries
    % ---------------------------
    haxes(tr) = axes('Units','Normalized', 'Position',[X Y sizewx sizewy].*s+q);
    plot([1:TSTEP:size(y,2)],squeeze(y(:,1:TSTEP:end,tr)'))
    set_axis
    axis([-inf inf ylimits]);
    axis on


    % set buttondownfcn on the axis
    %-----------------------------------
    set(haxes(tr),'buttondownfcn', @rej_callback_axisbuttondwn,...
        'color', get(hfig,'color'),'xcolor','w','ycolor','w');
%     if tr ~= ntr
%         set(haxes(tr),'xtick',[],'xticklabel', [], 'ytick',[],'yticklabel', []);
%     end
    % inactivate hittest for children of the axis
    % this makes it possible to detect mouse click on any places on the axis
    hc = get(haxes(tr),'children');
    for cc = 1 : length(hc), set(hc(cc),'Hittest', 'off'); end


    % plot the button
    % change axis color for possibly rejected trials
    %-----------------------------------------------
    hcheck(tr) = uicontrol(hfig, 'Style', 'checkbox', 'Units','Normalized', 'Position',...
        [X Y+sizewy sizewx sizewy*0.25].*s+q, 'value', 1, 'String', ['Trial' num2str(label(ix_tr_sort(tr)))], 'callback', @rej_callback_checkbox);

    drawnow;
    count = count +1;
end;

% draw the bottom button
% ----------------------
hcancel = uicontrol(hfig, 'Style', 'pushbutton', 'string', 'Cancel', 'Units','Normalized', 'backgroundcolor', GUIBUTTONCOLOR, ...
        'Position',[50 -10  15 sizewy*0.25].*s+q, 'callback', 'close(gcf); fprintf(''Operation cancelled\n''); pannel_rej = [];' );
hok = uicontrol(hfig, 'Style', 'pushbutton', 'string', 'OK', 'Units','Normalized', 'backgroundcolor', GUIBUTTONCOLOR, ...
        'Position',[90 -10  15 sizewy*0.25].*s+q, 'callback',  @rej_callback_mainokbutton);
hall = uicontrol(hfig, 'Style', 'pushbutton', 'string', 'ALL OFF', 'Units','Normalized', 'backgroundcolor', GUIBUTTONCOLOR, ...
        'Position',[70 -10  15 sizewy*0.25].*s+q, 'callback', @rej_callback_allbutton);
    
fprintf('press any keys \n');
pause

tr_bad = ix_tr_sort(pannel_rej);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Nested function
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % After clicking checkbox
    function rej_callback_checkbox(hObject,eventdata)
       
    end
    % After pushing 'All off' button
    function rej_callback_allbutton(hObject,eventdata)
         for ii = 1 : length(hcheck)
            set(hcheck(ii),'value',0);
         end
    end
    % After pushing OK, this function returns indicies of checked axis.
    function rej_callback_mainokbutton(hObject,eventdata)      
        % value of checkbox --> index rejected
        pannel_rej = [];
        for ii = 1 : length(hcheck)
            val = get(hcheck(ii),'value');
            if val == 1
                pannel_rej = [pannel_rej ii];
            end
        end
        close(hfig);
        figures = findobj('Tag', 'vb_plot_bad_trials2_detail');
        for k=1:length(figures)
            h_detail = figures(k);
            if ishandle(h_detail) ~= -1
                close(h_detail);
            end
        end
    end

    % After clicking axis.
    function rej_callback_axisbuttondwn(hObject,eventdata)
    
        hcurraxes = hObject;
        pannel_ind = find(haxes == hcurraxes);
        ytmp = squeeze(y(:,:,pannel_ind)); % Nch*Nt
        
        h = figure;
        set(h, 'Tag', 'vb_plot_bad_trials2_detail');

        plot(ytmp');
        title(['Trial= ' num2str(label(ix_tr_sort(pannel_ind)))])
        xlabel('time points')
        ylabel('amplitude')
    end


end
