function job_view_lf_selvertex(inst_id)
% Find nearest vertex from the selected point on GUI
% 
% --- Syntax
% function job_view_lf_selvertex(inst_id)
%
% --- History
% 2009-01-27 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rb1 = vbmeg_inst.viewlf{inst_id}.rb1;
ed1 = vbmeg_inst.viewlf{inst_id}.ed1;

%
% Cortical surface model displayed
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if get(rb1,'Value') == get(rb1,'Max'), 
  V = vbmeg_inst.viewlf{inst_id}.V; 
else 
  V = vbmeg_inst.viewlf{inst_id}.Vinf; 
end

%
% Vertex selection
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
k = waitforbuttonpress;
if k~=0, return; end;
p = (select3d)';
if length(p)==0, return; end; 
tmp = repmat(p,[size(V,1) 1]);
[tmp ixp] = min(sum((tmp-V).^2,2));
vbmeg_inst.viewlf{inst_id}.ix_selected_vertex = ixp;
set(ed1,'String',num2str(ixp));

%
% Update figure
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_view_lf_update_sensorpattern(inst_id); 
job_view_lf_update_cortexpattern(inst_id);
