function job_plot_meg_show_meginfo(inst_id)
% Show information of MEG data.
%
% [syntax]
% job_plot_meg_show_meginfo(inst_id)
%
% [history]
% 2008-09-02 Taku Yoshioka
% 2011-03-14 taku-y
%  [debug] If field 'MEG ID' does not exist, empty '' is shown. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

if isempty(vbmeg_inst.plotmeg{inst_id}.MEGinfo), 
  str = 'MEG data have not been loaded yet.';
else
  MEGinfo = vbmeg_inst.plotmeg{inst_id}.MEGinfo;
  vb_struct2vars(MEGinfo,{'MEG_ID','SampleFreq','Nchannel','Nrepeat', ...
                      'device'});
  str = sprintf(['MEG ID = %s \n' ...
                 'Sampling Frequency = %d [Hz]\n' ...
                 'Number of sensors = %d \n' ...
                 'Number of trials = %d \n' ...
                 'Device = %s'], MEG_ID, SampleFreq, Nchannel, Nrepeat, ...
                device);
end

h = msgbox(str,'MEG/EEG information');
