function job_plot_meg_print_spatialpattern(inst_id)
% Print contourmap of MEG signal. Invoked by job_plot_meg.
%
% [syntax]
% job_plot_meg_print_spatialpattern(inst_id)
%
% [history]
% ????-??-?? Masanori Osako
% 2008-12-09 Taku Yoshioka
% 2011-01-18 taku-y
%  [minor] Printing properties got by vb_property_dlg. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotmeg{inst_id}.bexp), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n_trial = vbmeg_inst.plotmeg{inst_id}.n_trial;
t       = vbmeg_inst.plotmeg{inst_id}.t;
pick    = vbmeg_inst.plotmeg{inst_id}.pick;
MEGinfo = vbmeg_inst.plotmeg{inst_id}.MEGinfo;
tt      = round((t(1):t(2))*MEGinfo.SampleFreq/1000+ ...
                vb_meginfo_get_pre_trigger(MEGinfo)+1);
bexp0   = mean(vbmeg_inst.plotmeg{inst_id}.bexp(:,tt,n_trial),2)';
cb1     = vbmeg_inst.plotmeg{inst_id}.cb1;
ed5     = vbmeg_inst.plotmeg{inst_id}.ed5;
cc_max  = max(max(abs(vbmeg_inst.plotmeg{inst_id}.bexp(:,:,n_trial))));

%
% Select sensor
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sensor_type = vbmeg_inst.plotmeg{inst_id}.sensor_type;

if sensor_type~=-1, 
  ix = find(MEGinfo.ChannelInfo.Type==sensor_type);
  bexp0 = bexp0(ix);
  pick = pick(ix,:);
end

%
% Figure property dialog
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
property_names = {'Colorbar','Max'};
c              = str2num(get(ed5,'String'));
if c<0, c=abs(c); end
default_values = {'1',num2str(c)};
description    ...
    = {'Colorbar is attached (1) or not (0).', ...
       'Maximum value of the absolute value plotted.'};
values = vb_property_dlg(property_names,default_values,description);

if isempty(values),
  return;
end

is_cbar = str2num(values{1});
c       = str2num(values{2});

%
% Draw and print contourmap
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Colormap
clim = [-c c];
%if get(cb1,'Value')==get(cb1,'Max')
%  clim = 0.7*[-cc_max cc_max];
%else
%  clim = [-1*max(abs(bexp0)) max(abs(bexp0))];
%end

% Display figure
h = figure; 
vb_plot_sensor_2d(pick(:,1:3),bexp0,clim);
vb_plot_sensor_2d_head_plot_add(gca);
axis off;
axis equal;
colormap(jet);
if is_cbar, colorbar; end
axis tight;
set(gca,'Position',[0.1 0.1 0.8 0.8]);

% Print figure
vb_epsfig(h,0.7,15);

[fig_dir,fig_file] = vb_file_select({'.eps'},'Save figure',true);
if ~isempty(fig_file), 
  figfile = [fig_dir filesep fig_file{1}];
  print(h,'-depsc',figfile);
end

close(h);

return;
