function job_plot_cmap_update_talcoord(inst_id)
% Update standard brain coordinate
%
% --- History
% 2008-10-03 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ix_peak = vbmeg_inst.plotcmap{inst_id}.ix_peak;
rb1 = vbmeg_inst.plotcmap{inst_id}.rb1;
rb2 = vbmeg_inst.plotcmap{inst_id}.rb2;
ed4 = vbmeg_inst.plotcmap{inst_id}.ed4;
ed6 = vbmeg_inst.plotcmap{inst_id}.ed6;

%
% Update standard brain coordinate
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(vbmeg_inst.plotcmap{inst_id}.ed4,'String',num2str(ix_peak)); 

if get(rb1,'Value')==get(rb1,'Max'), 
  Vstd = vbmeg_inst.plotcmap{inst_id}.Vtal;
else
  Vstd = vbmeg_inst.plotcmap{inst_id}.Vmni;
end

str = [num2str(ceil(Vstd(ix_peak,1))) ',' ...
       num2str(ceil(Vstd(ix_peak,2))) ',' ...
       num2str(ceil(Vstd(ix_peak,3)))];
set(vbmeg_inst.plotcmap{inst_id}.ed6,'String',str);
