function [result] = job_plot_cmap_setting_dlg_set_current_file(H, ...
                                                       curr_file, mode, trial)
% set current_file, mode(average or raw), trial number to this gui.
% [USAGE]
%    [result] = 
%      job_plot_cmap_setting_dlg_set_current_file(H, curr_file, mode, trial)
% [IN]
%    curr_file : cortical current file.
%         mode : load mode [string]
%                = 'ave'     : load average current
%                = 'raw'     : load single trial current
%        trial : trial number [integer]
% [OUT]
%    result : set result
%             = SUCCCESS : set success.
%             = FAILURE  : set failure
%                          - Specified extension is invalid.
%                          - Specified file does not exist.
%                            (except the case that the filename is empty.)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('H', 'var')
    error('H is a required parameter.');
end
if ~exist('mode', 'var')
    error('mode is a required parameter.');
end
if ~exist('trial', 'var')
    error('trial is a required parameter.');
end

%
% --- Main Procedure
%
result = SUCCESS;

% Set current_file name
result = job_plot_cmap_setting_dlg_set_file(H, curr_file, 'current_file');
if result == FAILURE, return; end
if isempty(curr_file), return; end

% Set current info
Jinfo = vb_load_current_info(curr_file);
set(H.max_trial_text, 'String', ['/' num2str(Jinfo.Ntrial)]);
setappdata(H.max_trial_text, 'max', Jinfo.Ntrial);

set(H.current_file_mode_average_radiobutton, 'Value', 0);
set(H.current_file_mode_raw_radiobutton, 'Value', 0);

% Set ave/raw mode radiobutton
switch(mode)
    case 'ave'
      job_plot_cmap_setting_dlg_callback(H, H.current_file_mode_average_radiobutton);
    case 'raw'
      job_plot_cmap_setting_dlg_callback(H, H.current_file_mode_raw_radiobutton);
    otherwise
        error('current_mode should be ''ave'' or ''raw''');
end

% Set trial number
prev_value = getappdata(H.current_file_mode_raw_edit);

if trial > Jinfo.Ntrial
    warning('Specified trial number is larger than trials which current file has.');
    trial = 1;
end
set(H.current_file_mode_raw_edit, 'String', num2str(trial));

% remember correct trial number as a previous valid value.
% This value will be used when the invalid trial index is specified.
setappdata(H.current_file_mode_raw_edit, 'prev', trial);
