function job_plot_cmap_push_zoom_button(inst_id)
% Change zoom mode
% 
% --- Syntax
% function job_plot_cmap_push_zoom_button(inst_id)
%
% --- History
% 2008-09-29 Taku Yoshioka
%
% [Note]
%    This function is not used on MATALB 2008b or later
%    because zoom function is always on and controlled by mouse wheel.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.plotcmap{inst_id}.h_fig;
h_space = vbmeg_inst.plotcmap{inst_id}.h_space;
h_time = vbmeg_inst.plotcmap{inst_id}.h_time;
h_zoom = vbmeg_inst.plotcmap{inst_id}.pb3;

%
% Change rotation mode and set callback function
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rot_flag = get(h_zoom, 'Value');
if rot_flag, 
    on_off = 'on';
else
    on_off = 'off';
end
zoom(h_fig, on_off);
