function job_plot_cmap_load_cortex(inst_id,brainfile,verbose)
% Load cortical surface model
%
% --- Syntax
% function job_plot_cmap_load_cortex(inst_id,brainfile,verbose)
%
% --- History
% 2008-09-01 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

error('This function will become obsolete. (Feb 20 2012 taku-y)')

%
% Load cortical surface model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~exist(brainfile),
  warndlg(['File ' brainfile ' does not exist.']);
  return; 
end

vbmeg_inst.plotcmap{inst_id}.brainfile = brainfile;

% Cortical surface model
[Vinf,F,xx,inf_C,xxA] = vb_load_cortex(brainfile,'Inflate');

if ~isempty(vbmeg_inst.plotcmap{inst_id}.Jact), 
  if max(vbmeg_inst.plotcmap{inst_id}.ix_act)>size(Vinf,1), 
    warndlg(['Index of dipole currents exceeds the number of ' ...
             'vertices.']);
    return;
  end
end
  
V = vb_load_cortex(brainfile);
vbmeg_inst.plotcmap{inst_id}.V = V;
vbmeg_inst.plotcmap{inst_id}.Vinf = Vinf;
vbmeg_inst.plotcmap{inst_id}.F = F;
vbmeg_inst.plotcmap{inst_id}.inf_C = inf_C;
vbmeg_inst.plotcmap{inst_id}.xxA = xxA;

% Standard brain coordinate
Vtal = vb_load_cortex(brainfile,'Talairach');
Vmni = vb_load_cortex(brainfile,'MNI');
if ~exist('Vtal','var') || isempty(Vtal), Vtal = zeros(size(V)); end
if ~exist('Vmni','var') || isempty(Vmni), Vmni = zeros(size(V)); end
vbmeg_inst.plotcmap{inst_id}.Vtal = Vtal*1e3;
vbmeg_inst.plotcmap{inst_id}.Vmni = Vmni*1e3;

% Load neighbour data for filter calculation
[nextDD,nextIX] = vb_load_cortex_neighbour(brainfile); 
vbmeg_inst.plotcmap{inst_id}.nextDD = nextDD;
vbmeg_inst.plotcmap{inst_id}.nextIX = nextIX;

%
% Update plots
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_plot_cmap_update_filterradius(inst_id);
job_plot_cmap_update_timecourse(inst_id); 
job_plot_cmap_update_spatialpattern(inst_id, true);
