function job_plot_cmap_change_talcoord(inst_id)
% Change standard brain coordinate
%
% --- History
% 2008-10-03 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ix_peak = vbmeg_inst.plotcmap{inst_id}.ix_peak;
rb1 = vbmeg_inst.plotcmap{inst_id}.rb1;
rb2 = vbmeg_inst.plotcmap{inst_id}.rb2;
ed4 = vbmeg_inst.plotcmap{inst_id}.ed4;
ed6 = vbmeg_inst.plotcmap{inst_id}.ed6;

%
% Update standard brain coordinate
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
v = str2num(get(ed6,'String'));
if length(v)~=3, 
  warndlg(['Coordinate values must be appropriate format \n' ...
           '(e.g., ''10, 20, 30'')'],'Warning');
  job_plot_cmap_update_talcoord(inst_id);
  return;
end

if get(rb1,'Value')==get(rb1,'Max'), 
  Vstd = vbmeg_inst.plotcmap{inst_id}.Vtal;
else
  Vstd = vbmeg_inst.plotcmap{inst_id}.Vmni;
end

% Find nearest vertex
d = repmat(v,[size(Vstd,1) 1])-Vstd;
d = sum(d.^2,2);
[tmp,vbmeg_inst.plotcmap{inst_id}.ix_peak] = min(d);

%
% Update figure
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_plot_cmap_update_timecourse(inst_id); 
job_plot_cmap_update_spatialpattern(inst_id);
