function job_edit_area_update_spatialpattern(inst_id)
%
% Update spatial pattern
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

% Global variables
h_fig = vbmeg_inst.editarea{inst_id}.h_fig; 
h_space = vbmeg_inst.editarea{inst_id}.h_space;
V = vbmeg_inst.editarea{inst_id}.V;
F = vbmeg_inst.editarea{inst_id}.F;
Iextract = vbmeg_inst.editarea{inst_id}.Iextract;
plot_parm = vbmeg_inst.editarea{inst_id}.plot_parm;
ed3 = vbmeg_inst.editarea{inst_id}.ed3;

% Patch color
if isfield(vbmeg_inst.editarea{inst_id},'inf_C'),
  inf_C = vbmeg_inst.editarea{inst_id}.inf_C;
else
  inf_C = [];
end

% Plot brain model
set(h_fig,'CurrentAxes',h_space);
cla; 
job_edit_area_plotbrain(plot_parm,V,F,inf_C,Iextract{1});
axis tight;
axis off;
axis equal;

% Vertex number
set(ed3,'String',num2str(length(Iextract{1})));

% Add drag/zoom function
vb_dragzoom(h_space, '3d');

% get view angle
[a, e] = view(h_space);

% set this value to get MATLAB to regcognize that the axes is 3D graphics.
% (if not set, zoom function behave strange.)
if a == 0 && e == 90
    view(h_space, [0, 89]);
end
