function vb_view_head_2d(analyze_file, head_file)
% View head model on MRI image
% [Usage]
%   vb_view_head_2d(analyze_file, head_file);
% [Input]
%   analyze_file : T1 structure file.
%      head_file : VBMEG head model file(.head.mat)
% [Output]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if nargin ~= 2
    error('Please check function usage.');
end
if exist(analyze_file, 'file') ~= 2
    error('Specified analyze file not found.');
end
if exist(head_file, 'file') ~= 2
    error('Specified head file not found.');
end

%
% --- Main Procedure
%
data_file = tempname;
vb_fsave(data_file, 'analyze_file', 'head_file');


% Set 2D view parameter
view2d_setting = bm_view_parm2d_new;
view2d_setting = bm_view_parm2d_set_analyze_file(view2d_setting, analyze_file);

view2d = bm_edit_app_view2d_new;
view2d = bm_edit_app_view_update(view2d, data_file, ...
                                 @inner_brain_load_display_factor, ...
                                 view2d_setting);
return;

%
% --- Inner function
%
function display_factor = inner_brain_load_display_factor(data_file)
% Create head file manager

load(data_file); % analyze_file, head_file

bm_obj = bm_manager_new;
[const] = define_bm_edit_app;
[bm_obj, result, bm_ix] = ...
        bm_manager_import_file(bm_obj, const.file_type.HEAD_FILE, ...
                               head_file, analyze_file);
if result == FAILURE
    errordlg('Failed to read brain file.');
    return;
end
display_factor = bm_manager_get_display_factor(bm_obj, bm_ix);
