function project_mgr_view_update(fig)
% update view of project_mgr gui.(after data loading, deleting...)
% [USAGE]
%    project_mgr_view_update(fig);
% [IN]
%    fig : figure handle of project_mgr_gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(fig);
H = data.H; % component handles

project_mgr_gui_reset(fig);

% figure title update
project_file = project_file_mgr('get_project_file');
set(H.figure, 'Name', ['project_mgr - ' project_file]);

% project setting update
project_name = project_file_mgr('get_project_name');
project_root = project_file_mgr('get_project_root');
set(H.project_root_edit, 'String', project_root);
set(H.project_name_edit, 'String', project_name);
set(H.dataimport_menu, 'Enable', 'on');
set(H.analysis_menu, 'Enable', 'on');
set(H.output_history_menu, 'Enable', 'on');

% get parameters and set to gui
[all_parms, parm_types] = project_file_mgr('get_all_parameters');
Nparm = length(all_parms);
listbox_lines = cell(0);
func_name = [];
for k=1:Nparm
    func_name = ...
        vb_judge_function_name(all_parms{k}, parm_types{k});

    parm_name_disp = get(H.parm_name_checkbox, 'Value');
    func_name_disp = get(H.func_name_checkbox, 'Value');

    if parm_name_disp
        parm_type = parm_types{k};
    else
        parm_type = [];
    end

    if ~func_name_disp
        func_name = [];
    end

    if parm_name_disp && func_name_disp
        sep = ' / ';
    else
        sep = ' ';
    end

    listbox_lines{k} = [ all_parms{k}.time_stamp, ' ' func_name sep parm_type ];
end
set(H.history_listbox, 'String', listbox_lines);

% Activate button status for 'Add to batch builder'
if Nparm > 0
    set(H.add_parm_to_builder_push, 'Enable', 'on');
else
    set(H.add_parm_to_builder_push, 'Enable', 'off');
end

project_mgr_view_update_builders(fig);

% Parameter view window update
project_mgr_callback(fig, H.history_listbox);
