function project_mgr_uimenu_help_callback(fig, hObj)
% callback function for uimenu 'Help'.
% [USAGE]
%    project_mgr_uimenu_file_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of project_mgr gui.
%    hObj : event component handle
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('fig', 'var') || isempty(hObj)
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(fig);
H = data.H; % component handles

switch(hObj)
    case H.help_overview
        url = vb_users_manual_url('Overview');
        vb_browser_show(url);
    case H.help_startup
        url = vb_users_manual_url('Project manager startup');
        vb_browser_show(url);
end
