function project_mgr_export_as_script(proj_root, parm, parm_type)
% Export parameter as a M-file.
% [USAGE]
%    project_mgr_export_as_script(proj_root, parm);
% [IN]
%    proj_root : project root directory.
%         parm : execusion parameter.
%    parm_type : parameter type(string)
%                (e.g. 'brain_parm', 'head_parm')
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proj_root', 'var')
    error('proj_root is a required parameter.');
end
if ~exist('parm', 'var')
    error('parm is a required parameter.');
end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end

%
% --- Main Procedure
%
  
% get job function name
func_name = vb_judge_function_name(parm, parm_type);
if strcmp(func_name, 'unknown')
    errordlg('Cannot export as M-file(Unknown parameter was specified).', 'error');
    return;
end

% Open save dialog
[d, f] = vb_file_select({'.m'}, 'Export as M-file.', true);
if isempty(d), return; end

% Save as M-file
mfile = fullfile(d, f{1});
if exist(mfile, 'file') == 2
    msg = [mfile ' already exists. Do you want to overwrite it?'];
    res = questdlg(msg, 'Confirm', 'Yes', 'No', 'Yes');
    if strcmp(res, 'No'), return; end
end
fid = fopen(mfile, 'wt');
if fid == -1
    error('Cannot open M-file.', 'error');
    return;
end

% Convert parm to str
if isfield(parm, 'caller_function')
    parm = rmfield(parm, 'caller_function');
end
if isfield(parm, 'time_stamp')
    time_stamp = parm.time_stamp;
    parm = rmfield(parm, 'time_stamp');
end
parm_str = vb_struct2executable_str(parm, parm_type);

% write script
fprintf(fid, 'function %s\n', strrep(f{1}, '.m', ''));
if exist('time_stamp', 'var')
    fprintf(fid, ['%% original parameter(' time_stamp, ')\n']);
end
fprintf(fid, '\n%% Project root directory\n');
fprintf(fid, 'proj_root = ''%s'';\n\n', proj_root);
fprintf(fid, '%% Parameter\n');
fprintf(fid, '%s\n', parm_str);
fprintf(fid, '%% Execute job function\n');
fprintf(fid, '%s(proj_root, %s);\n', func_name, parm_type);

fclose(fid);
h = msgbox([mfile ' was created.'], 'Notice');
waitfor(h);
edit(mfile);
