function project_mgr_callback(fig, hObj)
% callback function for project_mgr gui
% [USAGE]
%    project_mgr_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of project_mgr gui.
%    hObj : event component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('fig', 'var') || isempty(hObj)
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(fig);
H = data.H; % component handles

% % protect application screen
% set(fig, 'HandleVisibility', 'off');

switch(hObj)
    case H.history_listbox
        selected_line_no = get(H.history_listbox, 'Value');
        max_line_no = length(get(H.history_listbox, 'String'));

        % project is not loaded.
        if max_line_no == 0
            return;
        end

        % illigal selection check
        if (max_line_no < selected_line_no)
            selected_line_no = max_line_no;
        end

        % set parameter string
        [parm, parm_type] = project_file_mgr('get_parameter', selected_line_no);
        set(H.history_listbox, 'Value', selected_line_no);
        set(H.parameter_display_edit, 'String', vb_struct2str(parm));
        
        % set parm info to gui of check model.
        parm_info = [parm.time_stamp, ' ', parm_type];
        switch(parm_type)
            case 'brain_parm'
                set(H.brain_parm_edit, 'String', parm_info);
                data = project_mgr_set_ix_for_check_model(data, ...
                                           'brain_parm', selected_line_no);
            case 'fmri_parm'
                set(H.fmri_parm_edit, 'String', parm_info);
                data = project_mgr_set_ix_for_check_model(data, ...
                                           'fmri_parm', selected_line_no);
            case 'meg_parm'
                set(H.meg_parm_edit, 'String', parm_info);
                data = project_mgr_set_ix_for_check_model(data, ...
                                           'meg_parm', selected_line_no);
        end
        project_mgr_contextmenu_open(data);
    case {H.check_brain_model_push, H.check_brain_inflate_model_push}
        ix = project_mgr_get_ix_for_check_model(fig, 'brain_parm');
        if ix == 0
            errordlg('brain_parm is not selected.', 'error');
        else
            proj_root = get(H.project_root_edit, 'String');
            brain_parm = project_file_mgr('get_parameter', ix);

            if hObj == H.check_brain_model_push
                % Check brain model by 3D & MRI image
%                 vb_view_cortex_2d(brain_parm.analyze_file, ....
%                                   fullfile(proj_root, brain_parm.brain_file));
                vb_check_brain_model(proj_root, brain_parm);
            else
                % Plot Inflate model
                vb_check_inflate_model(proj_root, brain_parm);
            end
        end
    case H.check_fmri_parm_push
        ix = project_mgr_get_ix_for_check_model(fig, 'fmri_parm');
        if ix == 0
            errordlg('fmri_parm is not selected.', 'error');
        else
            proj_root = get(H.project_root_edit, 'String');
            fmri_parm = project_file_mgr('get_parameter', ix);
            % Check fMRI activity
            vb_check_fmri(proj_root, fmri_parm);
        end
    case H.check_meg_parm_push
        ix_brain = project_mgr_get_ix_for_check_model(fig, 'brain_parm');
        ix_meg   = project_mgr_get_ix_for_check_model(fig, 'meg_parm');
        if ix_brain == 0
            errordlg('brain_parm is not selected.', 'error');
        elseif ix_meg == 0
            errordlg('meg_parm is not selected.', 'error');
        else
            proj_root = get(H.project_root_edit, 'String');
            brain_parm = project_file_mgr('get_parameter', ix_brain);
            meg_parm = project_file_mgr('get_parameter',   ix_meg);
            % Check position of sensor and brain
            vb_job_check_sensor_on_brain(proj_root, brain_parm, meg_parm);
        end
    case {H.parm_name_checkbox, H.func_name_checkbox}
        project_mgr_view_update(fig);
    case H.add_parm_to_builder_push
        % Add selected parameter to selected batch file builder
        selected = get(H.history_listbox, 'Value');
        if selected > 0
            data = project_mgr_builder_open(data);
            [parm, parm_type] = project_file_mgr('get_parameter', selected);
            vb_batch_list_add_item(data.batch_fig, parm, parm_type);
        end
    case H.add_builder_push
        [data, name] = project_mgr_builder_add(data);
        guidata(fig, data);
        % update screen
        project_mgr_view_update_builders(fig);
        msgbox(sprintf('''%s'' was added.', name), 'Notice');
    case H.copy_builder_push
        [data, new_name] = project_mgr_builder_copy(data);
        guidata(fig, data);
        % update screen
        project_mgr_view_update_builders(fig);
        msgbox(sprintf('''%s'' was added.', new_name), 'Notice');
    case H.remove_builder_push
        % Confirm remove builder?
        idx = get(H.builder_popup, 'Value');
        rbuilder = data.batch_builders{idx};
        name     = vb_batch_mgr_get_name(rbuilder);
        res = questdlg(sprintf('Remove ''%s''?', name), 'Confirm', ...
                       'Yes', 'No', 'No');
        if strcmpi(res, 'no'), return; end
        [data, name] = project_mgr_builder_remove(data);
        guidata(fig, data);
        % update screen
        project_mgr_view_update_builders(fig);
        msgbox(sprintf('''%s'' was removed.', name), 'Notice');
    case H.open_builder_push
        data = project_mgr_builder_open(data);
    case H.export_mscript_push
        proj_root = get(H.project_root_edit, 'String');
        selected_line_no = get(H.history_listbox, 'Value');

        [parm, parm_type] = project_file_mgr('get_parameter', selected_line_no);
        if ~isempty(parm)
            project_mgr_export_as_script(proj_root, parm, parm_type);
        end
end

guidata(fig, data);

% protect application screen end
if ishandle(fig)
    set(fig, 'HandleVisibility', 'callback');
end
