function [data, name] = project_mgr_builder_add(data)
% Create new batch builder
% [USAGE]
%    [data] = project_mgr_builder_add(<data>);
% [IN]
%    data : project_mgr data
% [OUT]
%    data : project_mgr data(updated)
%    name : added builder name
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%

% Make new builder
Nbuilders   = length(data.batch_builders);
name        = ['batch builder' num2str(Nbuilders+1)];
data.batch_builders{Nbuilders+1, 1} = vb_batch_mgr_new(name);

% Save builders to file
batch_builders = data.batch_builders;
result = vb_save(data.project_file, 'batch_builders');

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
