function [fig] = pa_yokogawa_meg_create(proj_root)
% This function creates yokogawa meg parameter gui.
% [USAGE]
%    fig = pa_yokogawa_meg_create([proj_root]);
% [IN]
%    proj_root : project root directory.
% [OUT]
%    fig : figure handle of yokogawa meg gui.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proj_root', 'var')
    proj_root = [];
end

%
% --- Main Procedure
%
fig = openfig('pa_yokogawa_meg.fig');

data = struct;
data.H = guihandles(fig);
data.H.figure = fig;
data.yokogawa_meg_parm = vb_set_yokogawa_meg_parm;
data.output_filename   = '';
data.adv_fig = -1; % figure handle of yokogawa_meg advanced parameter gui.

% save data to figure
guidata(fig, data);

set(data.H.project_root_edit, 'String', proj_root);
pa_yokogawa_meg_set_parm(fig, data.yokogawa_meg_parm);
