function pa_yokogawa_meg_callback(fig, hObj)
% callback function for yokogawa meg gui.
% [USAGE]
%    pa_yokogawa_meg_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of yokogawa meg gui.
%    hObj : event component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure is specified.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
define = vbmeg_inst.const;

% load data(@see pa_yokogawa_meg_create)
data = guidata(fig);
H = data.H;

switch(hObj)
    case H.project_root_push
        dir_name = dir_dialog(get(H.project_root_edit, 'String'));
        if dir_name ~= 0
            set(H.project_root_edit, 'String', dir_name);
        end
    case H.meg_file_push
        [dir_name fname] = vb_file_select({'.raw', '.ave', '.con'}, 'Select Yokogawa MEG file');
        if ~isempty(dir_name)
            set(H.meg_file_edit, 'String', [dir_name filesep fname{1}]);
            pa_yokogawa_meg_util(fig, 'update_exec_push_status');
            pa_yokogawa_meg_util(fig, 'update_output_fname');
            % clear eeg_gain information
            data.yokogawa_meg_parm.ex_ch_gain = [];
            set(H.gain_setting_text, 'String', 'None');
            % save data
            guidata(fig, data);
        end
    case H.position_file_push
        [dir_name fname] = vb_file_select({'.pos.mat'}, 'Select positioning file');
        if ~isempty(dir_name)
            set(H.position_file_edit, 'String', [dir_name filesep fname{1}]);
            pa_yokogawa_meg_util(fig, 'update_output_fname');
        end
    case H.ext_gain_push
        pa_yokogawa_meg_edit_extra_channel_gain(fig);
    case H.save_dir_push
        proj_root = get(H.project_root_edit, 'String');
        [dir_name canceled] = pa_prjdir_select(proj_root);
        if ~canceled
            set(H.save_dir_edit, 'String', dir_name);
        end
        pa_yokogawa_meg_util(fig, 'update_output_fname');
    case H.change_output_file_push
        res = inputdlg('', 'New output filename');
        if iscell(res) && length(res) >= 1
            res = res{1};
        end
        if ~isempty(res)
            data.output_filename = res;
            guidata(fig, data);
        end
        pa_yokogawa_meg_util(fig, 'update_output_fname');        
    case H.exec_push
        pa_yokogawa_meg_util(fig, 'exec_meg');
    case {H.figure, H.menu_close}
        pa_yokogawa_meg_close(fig);
        return;
    case H.menu_import_meg_data
        url = vb_users_manual_url('MEG data');
        vb_browser_show(url);
end


