function [fig] = pa_sbi_meg_create(proj_root)
%  This function creates sbi meg parameter gui.
% [USAGE]
%    fig = pa_leadfield_create([proj_root]);
% [IN]
%    proj_root : project root directory.
% [OUT]
%    fig : figure handle of sbi meg parameter gui.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proj_root', 'var')
    proj_root = [];
end

%
% --- Main Procedure
%
fig = openfig('pa_sbi_meg.fig');

data = struct;
data.H = guihandles(fig);
data.H.figure = fig;
data.sbi_meg_parm = vb_set_sbi_meg_parm;
data.adv_fig = -1; % figure handle of leadfield advanced parameter gui.

% save data to figure
guidata(fig, data);

set(data.H.prjroot_edit, 'String', proj_root);
pa_sbi_meg_set_parm(fig, data.sbi_meg_parm);
