function [msg, msg_filtered] = vb_get_error_msg(lasterror_struct)
% return error message string.
% [USAGE]
%    [msg, msg_filtered] = vb_filt_get_error_msg(lasterror);
% [IN]
%    lasterror_struct : <<struct>> returned by "lasterror()" function.
% [OUT]
%             msg : original message(it refers to lasterror_struct.message)
%    msg_filtered : filtered message(This string doesn't include
%                                     error filename and line.)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

msg = lasterror_struct.message;

msg_filtered = [];
ix = strfind(lasterror_struct.message, sprintf('\n'));
if ~isempty(ix);
    msg_filtered = msg(ix(1)+1:end);
else
    msg_filtered = msg;
end
