function vb_timeseries_viewer_ex_update_trial(fig, trial_list)
% external interface function for updating trial list.
% [USAGE]
%    vb_timeseries_viewer_ex_update_trial(fig, trial_list);
% [IN]
%           fig : figure handle of vb_timeseries_viewer.
%    trial_list : trial_list
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || ~ishandle(fig) || isempty(fig)
    return;
end
if ~exist('trial_list', 'var')
    error('trial_list is a required parameter.');
end

%
% --- Main Procedure
%
obj = guidata(fig);
obj = vb_timeseries_viewer_set_trial(obj, trial_list);
obj = vb_timeseries_viewer_plot_trial(obj);
