function [obj] = vb_timeseries_viewer_update_display_time_range(obj)
% update display time range.
% [USAGE]
%    [obj] = vb_timeseries_viewer_update_range(obj);
% [IN]
%    obj : vb_timeseries_viewer object.
% [OUT]
%    obj : vb_timeseries_viewer object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%
H = obj.H;

set(obj.figure, 'Pointer', 'watch');

Nsample = obj.Nsample;
freq    = obj.freq;

val = get(H.timeseries_slider, 'Value');

max_sec  = Nsample/freq;

% Display area
% 0s                     max_sec
%  |---|----------------|---|
%      |<--- 0 to 1 --->|
%  0 = window_len/2
%  1 = max_sec - window_len/2

window_center = (max_sec - obj.window_len) * val + obj.window_len/2;
window_from = window_center - obj.window_len/2;
window_to   = window_center + obj.window_len/2;

% slider_step = get(H.timeseries_slider, 'SliderStep');
% if obj.window_len > max_sec/2
%     slider_step(2) = 1;
% %    set(obj.H.timeseries_slider, 'Value', 0.5);
% else
%     slider_step(2) = 0.01;
% end
% set arrow moving step(ratio)
ratio_arrow = obj.window_len / ((obj.total_time_sec) * 8);
mov = get(H.timeseries_slider, 'SliderStep');
mov(1) = min(ratio_arrow, 1);     % arrow push
mov(2) = min(ratio_arrow*3, 1); % bar push
set(H.timeseries_slider, 'SliderStep', mov);

update = true;
drag_state = getappdata(H.timeseries_slider, 'dragging');
if get(obj.H.stop_draw_dragging_check, 'Value') && ...
   ~isempty(drag_state) && drag_state
   update = false;
end

if update
    % set Measurement data range
%    tic;
    obj = vb_timeseries_viewer_plot_measurement_data(obj, window_from, window_to);
    obj = vb_timeseries_viewer_plot_trigger_data(obj, window_from, window_to);
    obj = vb_timeseries_viewer_plot_trial(obj, window_from, window_to);
    drawnow;
%    toc;

    if ~ishandle(obj.figure), return; end
    % Update Trigger Y-range
    if ~get(H.trigger_yrange_fix_check, 'Value')
        % if auto range, set value to editbox
        yrange = ylim(H.trigger_axes);
        set(H.ylimit_trigger_low_edit, 'String', num2str(yrange(1)));
        set(H.ylimit_trigger_high_edit, 'String', num2str(yrange(2)));
    end
end

set(H.timepoint_current_text, 'String', num2str(sprintf('%.3f', window_center)));
set(H.time_max_text, 'String', num2str(max_sec));

%set(H.timeseries_slider, 'min',

set(obj.figure, 'Pointer', 'arrow');
% debug
%disp('pointer ->arrow');
set(H.window_from_edit, 'String', num2str(window_from));
set(H.window_to_edit, 'String', num2str(ceil(window_to)));


%set(H.plotting_radio_button, 'Value', 0);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive vb_timeseries_viewer object.');
end
