function [obj] = vb_trigger_new(ch_name, trig_type, trig_level)
% This is a virtual function.
% DO NOT CALL DIRECTORY.
% This function assumed to be called from inherit class.
% [USAGE]
%    obj = vb_trigger_new(ch_name, trig_type, trig_level);
% [IN]
%       ch_name : extract trigger from this channel(s) [string or cell]
%     trig_type : trigger type such as 'voice' 'integer', 'analog', 'emg'
%    trig_level : trigger level. 
%                 The meaning of this parameter will vary by the type of trigger.
% [OUT]
%    obj : trigger object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin < 3
    error('This funcion needs 3 arguments. Please check your code.');
end
if ~iscellstr(ch_name) && ~ischar(ch_name)
    error('Invalid channel name was specified.');
end
if ~ischar(trig_type)
    error('Invalid trigger type was specified.');
end
if ~isempty(trig_level) && ~isnumeric(trig_level)
    error('Invalid trigger level was specified.');
end

%
% --- Main Procedure
%
obj = struct;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% obj.FIELDNAMES SHOULD BE SAME WITH vb_get_trial_time_index
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ischar(ch_name)
    obj.status_ch = {ch_name};
elseif iscellstr(ch_name)
    obj.status_ch = ch_name;
end

obj.trig_type    = trig_type;
obj.status_level = trig_level;

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
