function [tag_obj] = vb_tag_remove_trial_index(tag_obj, ix)
% remove trial index from tag.
% [USAGE]
%    [tag_obj] = vb_tag_remove_trial_index(tag_obj, ix);
% [IN]
%    ix : remove index number [Nx1]
% [OUT]
%    tag_obj : updated tag_object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('tag_obj', 'var')
    error('tag_obj is a required parameter.');
end
if ~exist('ix', 'var')
    error('ix is a required parameter.');
end

if size(ix, 2) ~= 1
    error('The shape of index should be [Nx1]');
end

%
% --- Main Procedure
%
remove_ix = [];
for k=1:length(ix)
    remove_ix = [remove_ix; find(tag_obj.trial_ix == ix(k))];
end
if ~isempty(remove_ix)
    tag_obj.trial_ix(remove_ix) = [];
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive updated tag_obj.');
end
