function [obj] = vb_multi_trigger_new(ch_name, slope, pattern)
% Create multi channel pattern trigger.
%
% [USAGE]
%    [obj] = vb_multi_trigger_new(ch_name, pattern);
% [IN]
%    ch_name : extract trigger from this channel(s) [string or cell]
%      slope : trigger slope. ('const_start' or 'const_end') [string]
%    pattern : Channel pattern. each index correspond to each ch_name. [0 or 1]
%              e.g. ch_name = {'420', '421', '422', '423'}
%                   pattern = [1, 0, 0, 1];
% [OUT]
%    obj : multi_trigger object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin < 3
    error('This function needs 3 argments. Please check your code.');
end
if ~iscellstr(ch_name) && ~ischar(ch_name)
    error('ch_name must be char array or cell array of strings');
end
if ~strcmp(slope, 'const_start') && ~strcmp(slope, 'const_end')
    error('trigger slope must be const_start or const_end');
end

%
% --- Main Procedure
%
obj = vb_trigger_new(ch_name, 'multi', pattern);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% obj.FIELDNAMES SHOULD BE DEFINED FOR vb_get_trial_time_index
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
obj.slope = slope;

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
