function [obj] = vb_analog_trigger_new(ch_name, slope, trig_level)
% Create analog trigger.
%
% [USAGE]
%    vb_analog_trigger_new(ch_name, slope trig_level);
% [IN]
%       ch_name : extract trigger from this channel [string]
%         slope : trigger slope. ('low_to_high' or 'high_to_low') [string]
%    trig_level : factor for amplitude threshold.
% [OUT]
%           obj : analog_trigger object
% [see also]
%    vb_get_trigger_event
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin < 3
    error('This function needs 3 argments. Please check your code.');
end
if ~strcmp(slope, 'low_to_high') && ~strcmp(slope, 'high_to_low')
    error('trigger slope must be low_to_high or high_to_low');
end

%
% --- Main Procedure
%
obj = vb_trigger_new(ch_name, 'analog', trig_level);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% obj.FIELDNAMES SHOULD BE DEFINED FOR vb_get_trial_time_index
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
obj.slope = slope;

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
