function [data] = vb_trial_extractor_show_channel_property(data)
% show channel property
% [USAGE]
%    [data] = vb_trial_extractor_show_channel_property(data);
% [IN]
%    data : vb_trial_extractor object.
% [OUT]
%    data : vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H = data.H;

val = get(H.trigger_channel_listbox, 'Value');

load_spec = struct;
load_spec.ChannelName = cell(0);
if ~isempty(val)
    text = [];
    list = get(H.trigger_channel_listbox, 'String');
    for k=1:length(val)
        load_spec.ChannelName{k} = list{val(k)};
    end
    con_file = vb_continuous_file_get_filename(data.continuous_file);
    [ch_data, ch_info] = vb_load_meg_data(con_file, load_spec);
    for k=1:length(ch_info.Name)
        ix = strmatch(list{val(k)}, ch_info.Name, 'exact');
        if ~isempty(ix)
            max_val = max(ch_data(ix, :));
            min_val = min(ch_data(ix, :));
            text = [text, sprintf('Ch:%s\n  Max = %f, Min = %f\n', ch_info.Name{ix}, max_val, min_val)];
        end
    end
    vb_text_area('Selected channel property', text);
end
