function [data] = vb_trial_extractor_input_multi_pattern(data)
% Input multi channel pattern.
% [USAGE]
%    [data] = vb_trial_extractor_input_multi_pattern(data);
% [IN]
%    data : vb_trial_extractor object.
% [OUT]
%    data : updated vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H = data.H;

% get selected trigger channel
ex_ch_list = get(H.trigger_channel_listbox, 'String');
if isempty(ex_ch_list), return; end
sl_ch_list = ex_ch_list(get(H.trigger_channel_listbox, 'Value'));
if ~iscellstr(sl_ch_list)
    sl_ch_list = {sl_ch_list};
end
Nch_sl = size(sl_ch_list, 1);

%                 strmatch                find
% Selected channel ------> Table channel -----> flag on table channel
table_ix = [];
table_ex_ch_list = data.multi_channel_pattern(:,1);
for k=1:Nch_sl
    % find index of selected channel from channel pattern table.
    table_ix = [table_ix; strmatch(sl_ch_list{k}, table_ex_ch_list, 'exact')];
end

if ~isempty(table_ix)
    flag_list = [data.multi_channel_pattern{:,2}]';
    % find flag on channel from selected channel.
    table_ix_flag_on = find(flag_list == 1);
    if isempty(table_ix_flag_on)
        flag_on_ch = [];
    else
        flag_on_ch = table_ex_ch_list(table_ix_flag_on);
    end
    [flag_on_ch, cancel] = vb_te_channel_selector_new(sl_ch_list, flag_on_ch);
end

if cancel == false
    for k=1:length(table_ix)
        if ~isempty(flag_on_ch) && ...
           ~isempty(strmatch(table_ex_ch_list{table_ix(k)}, flag_on_ch, 'exact'))
            data.multi_channel_pattern{table_ix(k), 2} = 1;
        else
            data.multi_channel_pattern{table_ix(k), 2} = 0;
        end
    end
end
        
%
% --- After check
%
if nargout ~= 1
    error('function caller should receive this object.');
end
