function [data] = vb_trial_extractor_edit_trial(data)
% Edit trial.
% [USAGE]
%    [data] = vb_trial_Extractor_edit_trial(data);
% [IN]
%    data : vb_trial_extractor object.
% [OUT]
%    data : updated vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H = data.H;

% Selected trial
N = get(H.trial_set_listbox, 'Value');
edit_index = data.showing_trial_ix(N);

trial = data.trial_list(edit_index);

% Sample Frequency [Hz]
freq = vb_continuous_file_get_sample_freq(data.continuous_file);
[Nsample] = vb_continuous_file_get_Nsample(data.continuous_file);

% Input onset time
onset = trial.onset;
MEGinfo = vb_continuous_file_get_meg_info(data.continuous_file);
MEGinfo = vb_meginfo_set_pre_trigger(MEGinfo, 0);
onset_sec = vb_index_to_time(onset, MEGinfo) / 1000;%[msec]->[sec]

err = true;
while(err)
    onset_sec_edit = inputdlg('Input trial onset time [sec]', ...
                              'Edit trial', ...
                              1, {num2str(onset_sec, 6)});
    if isempty(onset_sec_edit), return; end
    if isnan(str2double(onset_sec_edit))
        h = errordlg('Input value is not a number.', 'Edit trial');
        waitfor(h);
        continue; % back to top of while
    end

    % Sample number for Pre/Post period
    pretrigger  = ceil(data.trial_setting.pretrigger_ms  *(freq/1000));
    posttrigger = ceil(data.trial_setting.posttrigger_ms *(freq/1000));

    % calc sampling number
    onset_time       = round(str2double(onset_sec_edit{1}) * freq)+1; % 0[sec] = sample:1
    pretrigger_time  = onset_time - pretrigger;
    posttrigger_time = onset_time + posttrigger - 1;

    if pretrigger_time <= 0
        h = errordlg('Cant''t specify the onset time because pretrigger position is less than 0.', 'Edit trial');
        waitfor(h);
        continue; % back to top of while
    elseif posttrigger_time > Nsample
        h = errordlg('Can''t specify the onset time because posttrigger position is larger than data length.', 'Edit trial');
        waitfor(h);
        continue; % back to top of while
    end
    err = false; % normal exit of while
end

% Replace trial
trial_obj = vb_trial_new(pretrigger_time, posttrigger_time, onset_time);
data.trial_list(edit_index) = trial_obj; % overwrite

%
% --- Update viewer if a viewer is opened.
%

% multiple selection is prohibited by listbox
labels   = get(H.tag_listbox, 'String');
selected = get(H.tag_listbox, 'Value');
selected_label = labels{selected};
data = vb_trial_extractor_notify_viewer(data, selected_label);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive this object.');
end
