function vb_signal_processor_view_data_file(data, data_file)
% View data(MEG/EEG) file.
% [USAGE]
%    vb_signal_processor_view_data_file(data, data_file);
% [IN]
%         data : Application data.
%    data_file : MEG/EEG data file(.meg.mat/.eeg.mat)
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('data_file', 'var') || exist(data_file, 'file') ~= 2
    error('Specified MEG/EEG file not found.');
end

%
% --- Main Procedure
%
data_info = vb_load_meg_info(data_file);

file_type = 0;     % =0:Evoked, Averaged data format
                   % =1:Conitnuous data format
% switch(acq_type)
%     case {'Evoked_Ave', 'Evoked_Raw'}
%         file_type = 0;
%     case 'Continuous_Raw'
%         file_type = 1;
%     otherwise
%         error('Unknown acquisition type was found in specified MEG/EEG file');
% end
if data_info.Nrepeat == 1
    file_type = 1;
end

% View data
if file_type == 0
    job_plot_meg(data_file);
else
    % Get file type('MEG' or 'EEG')
    measurement   = vb_info_get_measurement(data_info);

    % Get Active data channel
    ch_info  = vb_load_channel_info(data_file, measurement);
    ch_list  = ch_info.Name(ch_info.Active == 1);

    % Get Active Extra data channel
    ch_info  = vb_load_channel_info(data_file, 'EXTRA');
    ex_ch_list = ch_info.Name(ch_info.Active == 1);

    % Decide display channenl number about 50 channel
    Ndata_ch = size(ch_list, 1);
    if Ndata_ch > 100
        step = ceil(Ndata_ch / 50);
        disp_ch_list = ch_list(1:step:Ndata_ch);
    else
        disp_ch_list = ch_list;
    end
    [disp_ch_list, cancel] = vb_te_channel_selector_new(...
                                                      ch_list,...
                                                      disp_ch_list,...
                                         'Choose data channel to display');
    if cancel, return; end

    % Decide display extra channel number
    [disp_ex_ch_list, cancel] = vb_te_channel_selector_new(...
                                                      ex_ch_list,...
                                                      [],...
                                         'Choose extra channel to display');
    if cancel, return; end

    % Launch timeseries viewer
    window_len = 30;
%    if isempty(disp_ch_list), disp_ch_list = {''}; end
%    if isempty(disp_ex_ch_list), disp_ex_ch_list = {''}; end
    h = vb_timeseries_viewer_new(data_file, window_len, ...
                             disp_ch_list, [], disp_ex_ch_list);
    set(h, 'Name', [measurement ' file:' data_file]);
end

