function [data] = vb_signal_processor_init(h)
% Initialize GUI of vb_signal_processor.
% [USAGE]
%     data = vb_signal_processor_init(h);
% [IN]
%    h : figure handle
% [OUT]
%    data : Initalized application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var') || isempty(data)
    data = struct;
end

% Gui component handles
H = guihandles(h);
data.H = H;

%
% --- Input MEG/EEG filename
%
data.input_files = cell(0);

%
% --- Output MEG/EEG filename
%
data.postfix = '_filt';
data.output_files = cell(0);
data.output_ix    = []; % see vb_signal_processor_confirm_overwrite_files.m

data.process_list = cell(0);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% set default value
%
data = vb_signal_processor_set_file_type(data, 'MEG');


%
% --- After check
%
if nargout ~= 1
    error('function caller should receive data object.');
end
