function data = vb_signal_processor_edit_parm(data, Nth)
% Edit Nth parameter on processing list.
% [USAGE]
%    data = vb_signal_processor_edit_parm(data, Nth);
% [IN]
%    data : Application data.
%     Nth : index number of processing list [integer]
% [OUT]
%    data : Updated application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('Nth', 'var')
    error('Nth is a required parameter.');
end

%
% --- Main Procedure
%
Ntool = length(data.process_list);
if Ntool < Nth
    error('Inconsistent data status (processing list and selected item).');
end

% Edit parameter
parm = data.process_list{Nth};
d = vb_define_signal_processor;
dlg_title = vb_table_query_value(d.type_str_table, parm.type);

check_ok = false;
while(check_ok == false)
	% Prepare for parameter editor.(parm -> editor format)
	editor_format = vb_signal_processor_util_convert_parm_to_editor(parm);

	% Edit
	[editor_format, cancel] = vb_input_settings(editor_format, dlg_title);
    if cancel, return; end

    % Convert (editor format -> parm)
    parm = vb_signal_processor_util_convert_editor_to_parm(editor_format, parm.type);

    % Check the validity of the parameter.
    [is_valid, reason] = vb_signal_processor_is_valid_parm(parm);

    if is_valid
        break;
    else
        d = vb_define_signal_processor;
        h = errordlg(reason, dlg_title);
        waitfor(h);
    end
end

% Update parameter.
data.process_list{Nth} = parm;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive data object.');
end
