function [is_ready] = vb_signal_processor_confirm_output_dir(data, mode)
% Confirm the existance of output directory.
% [USAGE]
%    [is_ready] = vb_signal_processor_confirm_output_dir(data);
% [IN]
%    data : Application data.
%    mode : confirm making directory or not.
%           = 0 : by text.
%           = 1 : by dialog.
%           = 2 : Yes.
%
% [OUT]
%    is_ready : output directory is ready or not. [Boolean]
%               = true: ready, false: not ready.
%               the flag also be false when the user 
%               choose "not to create directory'.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('mode', 'var')
    error('mode is a required parameter.');
end

%
% --- Main Procedure
%
% Get list of output directories.
outdir_list = vb_signal_processor_get_output_dir_list(data);

% Check existance of output directories
ix_not_exist = [];
for k=1:length(outdir_list)
    if exist(outdir_list{k}, 'dir') ~= 7
        ix_not_exist = [ix_not_exist; k];
    end
end

% Confirm to make directory or not?
if ~isempty(ix_not_exist)
    if mode == 0
       reply = '';
       while(isempty(reply))
           for k=1:length(ix_not_exist)
               fprintf('%s\n', outdir_list{ix_not_exist(k)});
           end
           reply = input('does not exist. create? (Yes/No):', 's');
           switch(lower(reply))
               case {'no', 'n'}
                   is_ready = false;
                   return;
           end
        end
    elseif mode == 1
        dlgTitle = 'Those directories will be created. OK?';
        [selection, IsOK] = listdlg('Name', dlgTitle, ...
                                    'SelectionMode', 'single', ...
                                    'ListString', outdir_list(ix_not_exist), ...
                                    'ListSize', [300, 300]);
        if ~IsOK
            is_ready = false;
            return;
        end
    elseif mode == 2
        % Do nothing
    else
        error('Unknown mode was specified.');
    end

    % Make directory
    for k=1:length(ix_not_exist)
        d_ = outdir_list{ix_not_exist(k)};
        result = vb_mkdir(d_);
        if result == false
            errmsg = sprintf('Failed to create directory : %s', d_);
            if mode == 1
                h = errordlg(errmsg, 'Create directory');
            end
            error(errmsg);
        end
    end
end

is_ready = true;
