function vb_signal_processor_callback(fig, hObj)
% Callback function of vb_signal_processor
% [USAGE]
%    vb_signal_processor_callback(h, hObj);
% [IN]
%     fig : figure handle of GUI.
%    hObj : get and set properties of the component that 
%           triggered execution of the callback.
% [OUT]
%    none
% [See also]
%    vb_signal_processor_new.m
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ishandle(fig) == 0
    error('Invalid figure handle was specified.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
get(hObj, 'Tag'); % debug

% loading application data from figure.
data = guidata(fig);
H    = data.H;

switch(hObj)
    case H.load_parameter_push
        data = vb_signal_processor_load_settings(data);
    case H.save_parameter_push
        data = vb_signal_processor_save_settings(data);
    case H.save_batch_file_push
        data = vb_signal_processor_save_batch_script(data);
    case H.file_type_meg_radiobutton
        data = vb_signal_processor_set_file_type(data, 'MEG');
    case H.file_type_eeg_radiobutton
        data = vb_signal_processor_set_file_type(data, 'EEG');
    case H.input_file_add_push
        data = vb_signal_processor_input_megfile(data);
    case H.input_file_remove_push
        Nth = get(H.input_file_listbox, 'Value');
        data = vb_signal_processor_remove_input_file(data, Nth);
    case H.input_file_view_push
        files = get(H.input_file_listbox, 'String');
        line  = get(H.input_file_listbox, 'Value');
        file = files{line};
        vb_signal_processor_view_data_file(data, file);
    case H.process_list_add_push
        % Get selected processing tool
        selected = get(H.process_type_listbox, 'Value');
        process_type = data.process_template{selected};
        % Add selected processing tool to the process list
        data = vb_signal_processor_add_tool_to_processlist(data, process_type);
    case H.process_type_listbox
        if strcmpi(get(H.figure, 'SelectionType'), 'open')
            % Get selected processing tool
            selected = get(H.process_type_listbox, 'Value');
            process_type = data.process_template{selected};
            % Add selected processing tool to the process list
            data = vb_signal_processor_add_tool_to_processlist(data, process_type);
        end
    case H.process_list_remove_push
        % Get remove index
        Nth = get(H.process_list_listbox, 'Value');
        data = vb_signal_processor_remove_parm_from_processlist(data, Nth);
    case H.process_list_listbox
         if strcmpi(get(H.figure, 'SelectionType'), 'open')
            % double click
            Nth = get(H.process_list_listbox, 'Value');
            data = vb_signal_processor_edit_parm(data, Nth);
         end
    case H.process_list_edit_push
        Nth = get(H.process_list_listbox, 'Value');
        data = vb_signal_processor_edit_parm(data, Nth);
    case H.process_list_view_push
        selected = get(H.process_list_listbox, 'Value');
        process_parm = data.process_list{selected};
        vb_signal_processor_view_filter_response(data, process_parm);
    case H.process_list_upper_push
        data = vb_signal_processor_change_process_order(data, 'upper');
    case H.process_list_lower_push
        data = vb_signal_processor_change_process_order(data, 'lower');
    case H.output_dir_push
        start_dir = get(H.output_dir_edit, 'String');
        d = dir_dialog(start_dir);
        if ~isempty(d), set(H.output_dir_edit, 'String', d); end
        data = vb_signal_processor_create_output_filename(data);
    case H.output_dir_edit
        d = get(H.output_dir_edit, 'String');
        if exist(d, 'dir') == 7 || isempty(d)
            data = vb_signal_processor_create_output_filename(data);
        else
            dlg= errordlg('Specified directory is invalid', 'output directory');
            waitfor(dlg);
            uicontrol(H.output_dir_edit);
        end
    case H.output_file_view_push
        files = get(H.output_file_listbox, 'String');
        line  = get(H.output_file_listbox, 'Value');
        file = files{line};
        vb_signal_processor_view_data_file(data, file);
    case H.exec_push
        vb_signal_processor_batch_exec(data, 1);
end
data = vb_signal_processor_update_screen(data);

% Store data
guidata(fig, data);
