function pa_leadfield_set_parm(fig, basis_parm)
% This function sets parameters to leadfield GUI.
% [USAGE]
%    pa_leadfield_set_parm(<fig> [,basis_parm]);
% [IN]
%           fig : figure handle of leafield gui.
%    basis_parm : to be set basis_parm [default:vb_set_basis_parm()]
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end

% default value
if isempty(basis_parm)
    basis_parm = vb_set_basis_parm;
end

%
% --- Main Procedure
%

% load data(@see pa_leadfield_create)
data = guidata(fig);
H = data.H; % component handles

% BRAIN file
set(H.brain_file_edit, 'String', basis_parm.brain_file);

% AREA file
set(H.area_file_edit, 'String', basis_parm.area_file);

% MEG-MAT file
set(H.megmat_file_edit, 'String', basis_parm.meg_file);

% HEAD file
set(H.head_file_edit, 'String', basis_parm.head_file);

% BEM mode
pa_leadfield_util(fig, 'set_bem_mode', basis_parm.bem_mode);

% Center of the head
if isfield(basis_parm, 'Vcenter')
    set(H.center_head_edit, 'String', num2str(basis_parm.Vcenter, 3));
end

% Conductivity
conduct_str = '';
Nlayer = length(basis_parm.sigma);
for k=1:Nlayer
    conduct_str = [conduct_str, num2str(basis_parm.sigma(k)) ', '];
    if k == Nlayer
        conduct_str = conduct_str(1:(length(conduct_str)-2));
    end
end
set(H.conductivity_edit, 'String', conduct_str);

% Radius
radius_str = '';
Nradius = length(basis_parm.radius);
for k=1:Nradius
    radius_str = [radius_str, num2str(basis_parm.radius(k)), ', '];
    if k == Nradius
        radius_str = radius_str(1:(length(radius_str)-2));
    end
end
set(H.sphere_radius_edit, 'String', radius_str);

% BASIS mode
pa_leadfield_util(fig, 'set_basis_mode', basis_parm.Basis_mode);

% normal mode
pa_leadfield_util(fig, 'set_normal_mode', basis_parm.normal_mode);

% Area key
set(H.areakey_edit, 'String', basis_parm.area_key);

%Save dir
[save_dir] = vb_get_file_parts(basis_parm.basis_file);
set(H.save_dir_edit, 'String', save_dir);

% BASIS file(output)
set(H.basis_file_edit, 'String', basis_parm.basis_file);

% save data
data.basis_parm = basis_parm;
guidata(fig, data);

% view update
pa_leadfield_util(fig, 'update_exec_push_status');
