function pa_head_set_parm(fig, head_parm)
% This function sets parameters to head GUI.
% [USAGE]
%    pa_head_set_parm(<fig> [,head_parm]);
% [IN]
%          fig : figure handle
%    head_parm : this parmeter is set to gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end

% default value
if isempty(head_parm)
    head_parm = vb_set_head_parm;
end

%
% --- Main Procedure
%

%
% --- The number of verticies
%

% load data(@see pa_head_create)
data = guidata(fig);

H = data.H; % component handles

set(H.model_1shell_radiobutton, 'Value', 0);
set(H.model_3shell_radiobutton, 'Value', 0);

set(H.vertices_3shell_edit, 'String', num2str(2000));
set(H.vertices_1shell_edit, 'String', num2str(6000));

if isfield(head_parm, 'Nsurf') && head_parm.Nsurf == 3
    if isfield(head_parm, 'Nvertex')
        set(H.vertices_3shell_edit, 'String', num2str(head_parm.Nvertex));
    else
        set(H.vertices_3shell_edit, 'String', num2str(2000));
    end
    set(H.model_3shell_radiobutton, 'Value', 1);
elseif isfield(head_parm, 'Nsurf') && head_parm.Nsurf == 1
    if isfield(head_parm, 'Nvertex')
        set(H.vertices_1shell_edit, 'String', num2str(head_parm.Nvertex));
    else
        set(H.vertices_1shell_edit, 'String', num2str(6000));
    end
    set(H.model_1shell_radiobutton, 'Value', 1);
else
    set(H.model_1shell_radiobutton, 'Value', 1);
end

if isfield(head_parm, 'vstep')
    vstep = head_parm.vstep;
end
set(H.voxel_size_edit, 'String', num2str(vstep));

%
% --- Analyze file
% 
if isfield(head_parm, 'analyze_file') && ~isempty(head_parm.analyze_file)
    set(H.analyze_file_edit, 'String', head_parm.analyze_file);
end

%
% --- CSF surface files
%
if isfield(head_parm, 'curry_file') && ~isempty(head_parm.curry_file)
    set(H.csf_source_popup, 'Value', 2);
    set(H.curry_file_edit, 'String', head_parm.curry_file);
elseif isfield(head_parm, 'gray_file')
    set(H.csf_source_popup, 'Value', 1);
else
    set(H.csf_source_popup, 'Value', 1);
end

% SPM gray matter file(.hdr)
if isfield(head_parm, 'gray_file') && ~isempty(head_parm.gray_file)
    set(H.gray_file_edit, 'String', head_parm.gray_file);
end

% Cortical surface file(.brain.mat)
if isfield(head_parm, 'brain_file') && ~isempty(head_parm.brain_file)
    set(H.brain_file_edit, 'String', head_parm.brain_file);
end

% FreeSurfer inner skull file(.asc)
if isfield(head_parm, 'freesurf_file') && ~isempty(head_parm.freesurf_file)
    set(H.fs_csf_file_edit, 'String', head_parm.freesurf_file);
end

% Morphological operation list([mm])
if isfield(head_parm, 'Radius_csf')
    set(H.gray_morphology_edit, 'String', ['[' num2str(head_parm.Radius_csf) ']']);
end
if isfield(head_parm, 'Radius')
    set(H.curry_morphology_edit, 'String', ['[' num2str(head_parm.Radius) ']']);
end
if isfield(head_parm, 'Radius_fs')
    set(H.fs_morphology_edit, 'String', ['[' num2str(head_parm.Radius_fs) ']']);
end

%
% --- Skull source
%
if isfield(head_parm, 'fs_skull_file') && ~isempty(head_parm.fs_skull_file)
    set(H.skull_source_popup, 'Value', 2);
    set(H.fs_skull_file_edit, 'String', head_parm.fs_skull_file);
else
    set(H.skull_source_popup, 'Value', 1);
end

% Minimum Skull thickness
if isfield(head_parm, 'Radius_skull')
    set(H.min_skull_thickness_edit, 'String', num2str(head_parm.Radius_skull));
end

% Scalp thickness
if isfield(head_parm, 'Radius_scalp')
    set(H.scalp_thickness_edit, 'String', num2str(head_parm.Radius_scalp));
end

%
% --- Scalp source
%
if isfield(head_parm, 'face_file') && ~isempty(head_parm.face_file)
    % Face surface file
    set(H.face_file_edit, 'String', head_parm.face_file);
    set(H.scalp_source_popup, 'Value', 2);
elseif isfield(head_parm, 'fs_scalp_file') && ~isempty(head_parm.fs_scalp_file)
    % FreeSurfer surface file(outer skin)
    set(H.fs_scalp_file_edit, 'String', head_parm.fs_scalp_file);
    set(H.scalp_source_popup, 'Value', 1);
else
    set(H.scalp_source_popup, 'Value', 1);
end

% Save dir
%[save_dir] = fileparts(head_parm.head_file);
if isfield(head_parm, 'head_file')
    [f_path, f_name, f_ext] = vb_get_file_parts(head_parm.head_file);
    set(H.save_dir_edit, 'String', f_path);
    % Make filename from vertex number.
    set(H.head_file_edit, 'String', head_parm.head_file);
end

% save head_parm
data.head_parm = head_parm;
guidata(fig, data);

% view update
pa_head_util(fig, 'update_model_type');
pa_head_util(fig, 'update_csf_source');
pa_head_util(fig, 'update_output_fname');
