function pa_fmri_parm_gui_close(fig)
% This function close fmri advanced parameter gui.
% [USAGE]
%    pa_fmri_parm_gui_close(<fig>);
% [IN]
%    fig : figure handle of fmri advanced parameter gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('figure handle is invalid.');
end

%
% --- Main Procedure
%

% load data(@see pa_fmri_create)
data = guidata(fig);
fig = data.H.figure;

% delete advanced parameter gui.
if ishandle(fig)
    delete(fig);
end
