function pa_brainamp_eeg_set_parm(fig, brainamp_eeg_parm)
% sets meg parameters to yokogawa meg gui.
% [USAGE]
%    pa_brainamp_eeg_set_parm(<fig>, [,brainamp_eeg_parm]);
% [IN]
%                  fig : figure handle of yokogawa meg gui.
%    brainamp_eeg_parm : to be set meg_parm[default:set_brainamp_eeg_parm()]
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end

if isempty(brainamp_eeg_parm)
    % default value
    brainamp_eeg_parm = vb_set_meg_parm_brainamp;
end

%
% --- Main Procedure
%

% load data(@see pa_brainamp_eeg_create)
data = guidata(fig);
H = data.H; % component handles

% proj_root
proj_root = get(H.project_root_edit, 'String');

% bdf file
set(H.brainamp_file_edit, 'String', brainamp_eeg_parm.measurement_file);

% position file
set(H.position_file_edit, 'String', brainamp_eeg_parm.pos_file);

% save dir
save_dir = vb_get_file_parts(brainamp_eeg_parm.output_file);
set(H.save_dir_edit, 'String', save_dir);

% EEG-MAT file
set(H.eegmat_file_edit, 'String', brainamp_eeg_parm.output_file);

% % Binary data directory
% set(H.binary_dir_edit, 'String', brainamp_eeg_parm.bin_data_dir);

% save data
data.brainamp_eeg_parm = brainamp_eeg_parm;
guidata(fig, data);

% view update
pa_brainamp_eeg_util(fig, 'update_exec_push_status');
