function pa_brain_merge_parm(fig, merge_parm)
% merge brain_parm which has brain gui has and inputted brain_parm fields.
% [USAGE]
%    pa_brain_merge_parm(<fig> <,brain_parm>);
% [IN]
%           fig : figure handle of brain parameter gui.
%    merge_parm : To be merged brain_parm.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var')|| isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end
if ~exist('merge_parm', 'var')
    error('merge_parm is a required parameter.');
end

%
% --- Main Procedure
%

% load data
data = guidata(fig);

parm_names = fieldnames(merge_parm);
for k=1:length(parm_names)
    data.brain_parm.(parm_names{k}) = merge_parm.(parm_names{k});
end

% save data
guidata(fig, data);

