function [fig] = pa_brain_create(proj_root)
% This function creates brain parameter gui.
% [USAGE]
%    fig = pa_brain_create([proj_root]);
% [IN]
%    proj_root : project root directory.
% [OUT]
%    fig : figure handle of brain gui.
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proj_root', 'var')
    proj_root = [];
end

%
% --- Main Procedure
%
fig = openfig('pa_brain.fig');

data = struct;
data.H = guihandles(fig);
data.H.figure = fig;
data.brain_parm = vb_set_brain_parm;
data.output_filename = '';
data.adv_fig = -1; % figure handle of brain advanced parameter gui.

% save data to figure
guidata(fig, data);

set(data.H.prjroot_edit, 'String', proj_root);
pa_brain_set_parm(fig, data.brain_parm);
