function pa_brain_parm_gui_close(fig)
% This function close brain advanced parameter gui.
% [USAGE]
%    pa_brain_parm_gui_close(<fig>);
% [IN]
%    fig : figure handle of brain advanced parameter gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('figure handle is invalid.');
end

%
% --- Main Procedure
%

% load data(@see pa_brain_create)
data = guidata(fig);
fig = data.H.figure;

% delete advanced parameter gui.
if ishandle(fig)
    delete(fig);
end
