function [varargout] = pa_biosemi_eeg_util(fig, command, parm)
% This function is subcontracting function of biosemi eeg gui.
% [IN]
%        fig : figure handle of biosemi eeg gui.
%    command : utility type
%       parm : other parameters
% [OUT]
%    varargout{n}: return value
%        @command : 'get_eeg_gain' ==> gain
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure was specified.');
end
if ~exist('command', 'var') || isempty(command)
    error('invalid command was specified.');
end

%
% --- Main Procedure
%

% load data(@see pa_biosemi_eeg_create)
data = guidata(fig);

switch(command)
    case 'update_output_fname'
        update_output_fname(data.H, data.output_filename);
    case 'update_exec_push_status'
        update_exec_push_status(data.H);
    case 'execute'
        exec(data);
    case 'reset_parameter'
        reset_parameter(data);
end

% save data
guidata(fig, data);

function update_output_fname(H, output_filename)
% This function makes output filename and sets filename to GUI.
% [IN]
%    H : GUI component handles
% [OUT]
%    none

    global vbmeg_inst;
    define = vbmeg_inst.const;

    filename = get(H.bdf_file_edit, 'String');
    [fpath, fname, fext] = vb_get_file_parts(filename);

    if ~isempty(output_filename)
        fname = output_filename;
    end

    % save directory
    save_dir = get(H.save_dir_edit, 'String');
    
    % save_dir/bdf_filename.eeg.mat
    eegmatfname = [save_dir filesep fname, define.EEG_EXTENSION];
    set(H.eegmat_file_edit, 'String', eegmatfname);

    % binary datadir name
    bin_dir = vb_device_make_data_dir(eegmatfname, 0);
    if length(bin_dir) >= 2 && ...
       (strcmp(bin_dir(1:2), './') || strcmp(bin_dir(1:2), '.\'))
       bin_dir = fullfile(save_dir, bin_dir(3:end));
    end
    set(H.binary_dir_edit, 'String', bin_dir);
    
    update_exec_push_status(H);

function update_exec_push_status(H)
% This function changes Exec button status.(clickable or not)
% [IN]
%    H : GUI component handles
% [OUT]
%    none

%       ~isempty(get(H.position_file_edit, 'String')) & ...

    if ~isempty(get(H.bdf_file_edit, 'String')) & ...
       ~isempty(get(H.save_dir_edit, 'String')) & ...
       ~isempty(get(H.eegmat_file_edit, 'String'))
        set(H.exec_push, 'Enable', 'on');
    else
        set(H.exec_push, 'Enable', 'off');
    end

function H = exec(data)
% This function execute vb_job_meg with set parameter.
% [IN]
%    data : data of biosemi eeg gui(@see pa_biosemi_eeg_create)
% [OUT]
%    none

    H = data.H; % component handles

    %%%%%%%%%%%%%%%%%%%%
    % Parameter setting
    %%%%%%%%%%%%%%%%%%%%

    % project root directory
    proj_root = get(H.project_root_edit, 'String');

    % device
%     meg_parm.Measurement     = 'EEG';
%     meg_parm.device          = 'BIOSEMI';

    % proj_root --- save_dir --- binary_dir
    %                         |- eeg_file
    save_dir   = get(H.save_dir_edit, 'String');
    eegmat_file  = get(H.eegmat_file_edit, 'String');

    
    % advanced parameters are set here.
    meg_parm = data.biosemi_eeg_parm;
    
    % BDF file.
    bdf_file = get(H.bdf_file_edit, 'String');
    meg_parm.measurement_file = bdf_file;
    
    % POS-MAT file.
    pos_file = get(H.position_file_edit, 'String');
    meg_parm.pos_file = pos_file;

    % EEG-MAT file.
    meg_parm.output_file   = eegmat_file;

    %%%%%%%%%%%%%%%%%%%%
    % execute job
    %%%%%%%%%%%%%%%%%%%%
    
    if exist(pos_file, 'file') == 2
        [ch_list_bdf] = vb_bdffile_get_info(bdf_file);
        [posinfo] = vb_posfile_get_posinfo(pos_file);
        ch_list_pos = posinfo.ChannelLabel;

        IsOK = vb_dlg_compare_list(ch_list_bdf, ...
                            ['BDF-file Channel list = ', num2str(length(ch_list_bdf))], ...
                            ch_list_pos, ...
                            ['POS-file Channel list = ', num2str(length(ch_list_pos))], ...
                            'Is channel list correct?');
        if ~IsOK, return; end
    end
    
    str = get(H.exec_push, 'String');
    set(H.exec_push, 'String', 'Processing...');
    pause(0.01); % for update button string

    vb_job_meg(proj_root, meg_parm);

    set(H.exec_push, 'String', 'Exec');

function data = reset_parameter(data)
% This function resets biosemi eeg GUI.
% [IN]
%    H : GUI component handles
% [OUT]
%    none

    H = data.H;
    
    meg_parm = vb_set_meg_parm_biosemi;
    pa_biosemi_eeg_set_parm(H.figure, meg_parm);
    data = guidata(H.figure);

