function [fig] = pa_biosemi_eeg_create(proj_root)
% This function creates yokogawa meg parameter gui.
% [USAGE]
%    fig = pa_biosemi_eeg_create([proj_root]);
% [IN]
%    proj_root : project root directory.
% [OUT]
%    fig : figure handle of yokogawa meg gui.
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proj_root', 'var')
    proj_root = [];
end

%
% --- Main Procedure
%
fig = openfig('pa_biosemi_eeg.fig');

data = struct;
data.H = guihandles(fig);
data.H.figure = fig;
data.biosemi_eeg_parm = vb_set_meg_parm_biosemi;
data.output_filename  = '';
data.adv_fig = -1; % figure handle of biosemi_eeg advanced parameter gui.

% save data to figure
guidata(fig, data);

set(data.H.project_root_edit, 'String', proj_root);
pa_biosemi_eeg_set_parm(fig, data.biosemi_eeg_parm);
