function [obj] = brain_file_maker_update_ui_state(obj)
% change ui status of brain_file_maker gui
% [USAGE]
%    [obj] = brain_file_maker_update_ui_state(<obj>);
% [IN]
%    obj : brain_file_maker object
% [OUT]
%    obj : brain_file_maker object
%
% Author: rhayashi
% Created: 2007-07-17
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
H = obj.H;
brain_dir = obj.brain_dir;

is_proj_root_inputted = ~isempty(obj.proj_root) && ...
                        (exist(obj.proj_root, 'dir') == 7);

% Processing target filenames
brain_file = [obj.proj_root, filesep, obj.brain_file];
area_file  = [obj.proj_root, filesep, obj.area_file];
act_file   = [obj.proj_root, filesep, obj.act_file];
output_mask_file = [obj.proj_root, filesep, obj.output_mask_file];

% Target file exist flags
brain_file_exist = (exist(brain_file, 'file') == 2);
area_file_exist  = (exist(area_file, 'file') == 2);
act_file_exist   = (exist(act_file, 'file') == 2);
spm_file_exist = (exist(obj.spm_norm_file, 'file') == 2);

%
% -- relation of proj_root
%
if is_proj_root_inputted
    enable = 'on';
else
    enable = 'off';
end

% Brain file directory
set(H.brain_dir_push, 'Enable', enable);
set(H.brain_dir_edit, 'Enable', enable);

% brain file output directory
set(H.brain_file_output_dir_edit, 'Enable', enable);
set(H.brain_file_output_dir_push, 'Enable', enable);

% 2D button state
if brain_file_exist && ~isempty(obj.analyze_info)
    set(H.view2d_push, 'Enable', 'on');
else
    set(H.view2d_push, 'Enable', 'off');
end

% 3D button state
if brain_file_exist
    set(H.view3d_push, 'Enable', 'on');
else
    set(H.view3d_push, 'Enable', 'off');
end

%
% -- Job button state
%

% Smoothing button state
if ~isempty(obj.analyze_info) && brain_file_exist && ...
    area_file_exist && act_file_exist
    
    set(H.make_smoothed_brain_push, 'Enable', 'on');
else
    set(H.make_smoothed_brain_push, 'Enable', 'off');
end

%
% --- make brain files from standard model button state
%
handles = H.make_brain_from_standard_push;

% Button Visibility
if obj.product_type == 1
    set(handles, 'Visible', 'on');
else
    set(handles, 'Visible', 'off');
end
% Button state    
if  ~isempty(obj.output_brain_file) && ~isempty(obj.output_area_file) && ...
    ~isempty(obj.output_act_file) && ...
    ~isempty(get(obj.H.brain_file_output_filename_edit, 'String')) && ...
    spm_file_exist

    set(handles, 'Enable', 'on');
else
    set(handles, 'Enable', 'off');
end

%
% --- make brain files from mask file button state
%
% Button Visibility
handles = [H.mask_file_text;
           H.make_brain_from_mask_push;
           H.output_mask_file_text];
if obj.product_type == 2
    set(handles, 'Visible', 'on');
else
    set(handles, 'Visible', 'off');
end
% Button state
if  ~isempty(obj.analyze_info) && length(output_mask_file) && ...
    ~isempty(obj.output_brain_file) && ~isempty(obj.output_area_file) && ...
    ~isempty(obj.output_act_file) && ...
    ~isempty(get(obj.H.brain_file_output_filename_edit, 'String')) && ...
    spm_file_exist

    set(H.make_brain_from_mask_push, 'Enable', 'on');
else
    set(H.make_brain_from_mask_push, 'Enable', 'off');
end


%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
