function brain_file_maker_callback(obj, hObj)
% Processing brain_file_maker gui callback.
% [USAGE]
%    brain_file_maker_callback(<obj>);
% [IN]
%    obj : brain_file_maker object
% [OUT]
%    none 
%
% Author: rhayashi
% Created: 2007-07-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
H = obj.H;

evalin('base', 'clear avw');

switch(hObj)
    case H.proj_root_push
        dir_name = get(H.proj_root_edit, 'String');
        if isempty(dir_name)
            dir_name = pwd;
        end
        dir_name = dir_dialog(dir_name);
        if ~isempty(dir_name)
            obj.proj_root = dir_name;
            obj = brain_file_maker_update_display(obj);
        end
    case H.proj_root_edit
        proj_root = get(hObj, 'String');
        if exist(proj_root, 'dir') == 7
            obj.proj_root = proj_root;
        else
            obj.proj_root = [];
        end
        % update ui status
        obj = brain_file_maker_update_display(obj);
    case H.analyze_file_push
        [dir_name, f_name] = visible(obj.fdlg_analyze);
        if ~isempty(dir_name)
            % get analyze file information 
            analyze_file = [dir_name, filesep, f_name{1}];
            obj.analyze_file = analyze_file;
            obj.analyze_info = vb_analyze_info_new(analyze_file);
            % update ui status
            obj = brain_file_maker_update_display(obj);
            % set selected directory for next dialog open.
            obj.fdlg_analyze = set(obj.fdlg_analyze, 'current_dir', dir_name);
        end
    case H.analyze_file_edit
        analyze_file = get(hObj, 'String');
        if exist(analyze_file, 'file') == 2
            obj.analyze_info = vb_analyze_info_new(analyze_file);
        else
            obj.analyze_info = [];
        end
        % update ui status
        obj = brain_file_maker_update_ui_state(obj);
    case H.product_type_popup
        obj.product_type = get(hObj, 'Value');
        % update ui status
        obj = brain_file_maker_update_ui_state(obj);
    case H.output_brain_file_comment
        obj.comment = get(hObj, 'String');
    case H.brain_dir_push
        dir_name = dir_dialog(obj.proj_root, false);
        if ~isempty(dir_name)
            rel_path = vb_relativepath(dir_name, obj.proj_root);
            set(H.brain_dir_edit, 'String', rel_path);
            obj.brain_dir = rel_path;
            obj = brain_file_maker_update_display(obj);
        end
    case H.brain_dir_edit
        obj.brain_dir = get(hObj, 'String');
        obj = brain_file_maker_update_display(obj);
    case H.filter_edit
        set(H.brain_file_listbox, 'Value', 1);
        set(H.area_file_listbox, 'Value', 1);
        set(H.act_file_listbox, 'Value', 1);
        obj = brain_file_maker_update_display(obj);
    case {H.brain_file_listbox, H.area_file_listbox, H.act_file_listbox}
        obj = brain_file_maker_set_selected_filename(obj);
        if hObj == H.brain_file_listbox & ishandle(obj.view2d)
            h = brain_file_maker_show_wait_dialog;
            obj = brain_file_maker_view2d(obj, ...
                    [obj.proj_root, filesep, obj.brain_file], obj.analyze_info);
            brain_file_maker_delete_wait_dialog(h);
        end
    %
    % --- Mask file maker
    %
    case H.spm_norm_file_push
        [dir_name, f_name] = visible(obj.fdlg_spm_norm_file);
        if ~isempty(dir_name)
            spm_norm_file = [dir_name, filesep, f_name{1}];
            % set selected directory for next dialog open.
            obj.fdlg_spm_norm_file = set(obj.fdlg_spm_norm_file,...
                                        'current_dir', dir_name);
            obj.spm_norm_file = spm_norm_file;
            % update ui status
            obj = brain_file_maker_update_display(obj);            
        end
    case H.spm_norm_file_edit
        obj.spm_norm_file = get(hObj, 'String');
        obj = brain_file_maker_update_ui_state(obj);
    case H.brain_file_output_filename_edit
        obj.brain_file_output_filename = get(hObj, 'String');
        obj = brain_file_maker_update_display(obj);
    case H.brain_file_output_dir_push
        [dir_name cancelled] = pa_prjdir_select(obj.proj_root);
        if ~cancelled
            obj.brain_file_output_dir = dir_name;
            obj = brain_file_maker_update_display(obj);
        end
    case H.brain_file_output_dir_edit
        obj.brain_file_output_dir = get(hObj, 'String');
        obj = brain_file_maker_update_display(obj);
                                        
    %
    % --- View/Edit callbacks
    %
    case H.view3d_push
        if isempty(obj.brain_file)
            errordlg('Brain file is not specified.', 'notice');
        else
            h = brain_file_maker_show_wait_dialog;
            obj = brain_file_maker_view3d(obj, ...
                    [obj.proj_root, filesep, obj.brain_file], ...
                    [obj.proj_root, filesep, obj.area_file], ...
                    [obj.proj_root, filesep, obj.act_file]);
            % 3Dɽjob_view_cortexư롣
            % job_view_cortexmri_point_selectǡ
            % figureϥɥ뤬ǽΤǡդդɬס
            % ɽѥץꥱλΥߥ󥰤ǤʤΤ
            % ư˥åɬפ롣
            if obj.view3d == obj.view2d
                obj.view2d = -1;
            end
            brain_file_maker_delete_wait_dialog(h);
        end
    case H.view2d_push
        if isempty(obj.brain_file)
            errordlg('Brain file is not specified.', 'notice');
        else
            h = brain_file_maker_show_wait_dialog;
            obj = brain_file_maker_view2d(obj,...
                    [obj.proj_root, filesep, obj.brain_file], obj.analyze_info);
            % 2Dɽmri_point_selectư롣
            % job_view_cortexmri_point_selectǡ
            % figureϥɥ뤬ǽΤǡդդɬס
            % ɽѥץꥱλΥߥ󥰤ǤʤΤ
            % ư˥åɬפ롣
            if obj.view2d == obj.view3d
                obj.view3d = -1;
            end
            brain_file_maker_delete_wait_dialog(h);
        end
%     %
%     % --- Parameter menu callbacks
%     %
%     case {H.job_smooth_cortex_parm_menu, H.job_brain_std2sbj_parm_menu}
%         const = define_brain_file_maker;
%         switch(hObj)
%             case H.job_smooth_cortex_parm_menu
%                 parm_type = const.JOB_SMOOTH_CORTEX_PARM;
%             case H.job_brain_std2sbj_parm_menu
%                 parm_type = const.JOB_BRAIN_STD2SBJ_PARM;
%             otherwise
%                 error('invalid parameter is specified.');
%         end
%         obj = brain_file_maker_edit_parm(obj, parm_type);
    %
    % --- Job callbacks
    %
    case H.make_smoothed_brain_push
        const = define_brain_file_maker;
        parm = job_smooth_cortex_parm_get_parm(obj.job_smooth_cortex_parm);
        % Open parameter edit dialog
        [obj, cancelled] = ...
            brain_file_maker_edit_parm(obj, const.JOB_SMOOTH_CORTEX_PARM);
        if cancelled, return; end
        output_dir = get(H.brain_dir_edit, 'String');
        % Make smoothed brain files
        [result, cancelled] = brain_file_maker_smooth_brainfiles(...
                                            obj, parm);
        if result == SUCCESS && cancelled == false
            obj = brain_file_maker_update_display(obj);
        end
    case H.make_brain_from_mask_push
        %
        % --- Execute make brain file from mask file.
        %
        const = define_brain_file_maker;
        parm = job_brain_std2sbj_parm_get_parm(obj.job_brain_std2sbj_parm);
        comment = get(H.output_brain_file_comment, 'String');
        % Open parameter edit dialog
        [obj, cancelled] = ...
            brain_file_maker_edit_parm(obj, const.JOB_BRAIN_STD2SBJ_PARM);
        if cancelled, return; end
        
        % make mask file
        spm_norm_file = get(H.spm_norm_file_edit, 'String');
        output_mask_file = ...
            [obj.proj_root, filesep, get(H.output_mask_file_text, 'String')];
        global vbmeg_inst;
        standard_mask_file = vbmeg_inst.const.FILE_STD_BRAIN_MASK_MAT;
        [result, cancelled] = brain_file_maker_make_mask_file(...
                        obj, spm_norm_file, standard_mask_file, output_mask_file);
        if result == SUCCESS && cancelled == false
            obj = brain_file_maker_update_display(obj);
        elseif cancelled == true && exist(output_mask_file, 'file') == 2
            % use input file.(here, do nothing)
        elseif cancelled == true && exist(output_mask_file, 'file') ~= 2
            msgbox('Processing was aborted.');
            return;
        elseif result == FAILURE
            error('Error was occured when making Mask file.');
        end

        % make cortical files from mask file
        parm.spm_normalization_file = obj.spm_norm_file;
        [result, cancelled] = ...
            brain_file_maker_make_brainfiles_from_mask_file(obj, parm, comment);
        if result == SUCCESS && cancelled == false
            obj = brain_file_maker_update_display(obj);
        elseif cancelled == true
            msgbox('Processing was aborted.');
        else
            error('Error was occured when making Cortical files.');
        end
   case H.make_brain_from_standard_push
        comment = get(H.output_brain_file_comment, 'String');
        parm = obj.job_brain_model_std2sbj_parm;
        [result, cancelled] = brain_file_maker_make_brainfiles_from_standard_model(...
                               obj, parm, comment);
        if result == SUCCESS && cancelled == false
            obj = brain_file_maker_update_display(obj);
        elseif cancelled == true
            msgbox('Processing was aborted.');
        else
            error('Error was occured when making Cortical files.');
        end
end

%
% --- save application instance to figure
%
guidata(obj.H.figure, obj);
