function [obj] = state_set_state(obj, state, description)
% set state and description
% [USAGE]
%    [obj] = state_set_state(<obj>, <state>[, description]);
% [IN]
%            obj : state object
%          state : state value
%    description : <<string>> explanation of state.
% [OUT]
%    obj : state object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('state', 'var'), error('state is a required parameter.'); end
if ~exist('description', 'var')
    description = [];
end
if ~(isnumeric(state) || islogical(state)) || (length(state) ~= 1)
    error('state should be scalar.');
end

%
% --- Main Procedure
%
obj = struct;
obj.state = state;
obj.description = description;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
