function [obj] = ...
    mask_image_data_new(B, step, coord_type, model_name, conductivity)
% create mask_image_data object
% [USAGE]
%    [obj] = mask_image_data_new(
%                  <B>, <step>, <coord_type>[,model_name][,conductivity]);
% [IN]
%               B : mask image data
%            step : voxel size[mm]
%      coord_type : coordinate type of mask_image_data
%      model_name : model name of mask_image_data
%    conductivity : conductivity value
%
% [OUT]
%    obj : mask_image_data object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

const = define_bm_edit_app;

%
% --- Previous check
%
if ~exist('B', 'var'), error('B is a required parameter.'); end
if ~exist('step', 'var'), error('step is a required parameter.'); end
if ~exist('coord_type', 'var')
    error('coord_type is a required parameter.');
end
if ~exist('model_name', 'var') || isempty(model_name)
    model_name = 'mask image data';
end
if ~exist('conductivity') || isempty(conductivity)
    conductivity = const.DEFAULT_CONDUCTIVITY;
end

%
% --- Inheritance
%
obj = brain_data_new(coord_type, model_name, conductivity);

% set class type
obj.class_type = 'mask_image_data';

%
% --- Member initialize
%
obj.B = B;
obj.step = step;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
