function [new_model_cell] = bm_processor_separate_surf(obj, brain_data, parm)
% processing by vb_separate_surf()
% [USAGE]
%     [new_model_cell] =
%         bm_processor_separate_surf(<obj>, <brain_data>, <parm>);
% [IN]
%           obj : bm_processor object
%    brain_data : processing data
%          parm : processing parameter
% [OUT]
%    new_model_cell : cell of processed brain_data object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_data', 'var')
    error('brain_data is a required parameter.');
end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end

if ~strcmp(brain_data.class_type, 'surf_data')
    error('Not surface data was inputted.');
end


%
% --- Main Procedure
%
global vbmeg_inst;
const = vbmeg_inst.const;

% get processing data
V  = surf_data_get_vertex(brain_data);
F  = surf_data_get_face(brain_data);
xx = surf_data_get_normal_vector(brain_data);

% processing
[Fall, Vall] = vb_separate_surf(F, V, parm.seedID);

% create new data
Nmodel = length(Fall);
new_model_cell = cell(Nmodel, 1);
for k=1:Nmodel
    [xx_k, Fall{k}] = vb_out_normal_vect(Vall{k}, Fall{k});
    new_model_cell{k} = surf_data_new(Vall{k}, Fall{k}, xx_k, ...
                                const.COORDINATE_ANALYZE_RIGHT_MM); 
end
