function [new_brain_data] = bm_processor_combine_surf(obj, brain_data_cell, parm)
% processing by vb_combine_surf()
% [USAGE]
%     [new_brain_data] =
%         bm_processor_combine_surf(<obj>, <brain_data_cell>, <parm>);
% [IN]
%           obj : bm_processor object
%    brain_data : processing data
%          parm : processing parameter
% [OUT]
%    new_brain_data : processed data
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_data_cell', 'var')
    error('brain_data_cell is a required parameter.');
end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end

Ndata = length(brain_data_cell);
for k=1:Ndata
    if ~strcmp(brain_data_cell{k}.class_type, 'surf_data')
        error('Not surface data was inputted.');
    end
end


%
% --- Main Procedure
%
global vbmeg_inst;
const = vbmeg_inst.const;

Fall = cell(Ndata, 1);
Vall = cell(Ndata, 1);

for k=1:Ndata
    % get combine data
    V  = surf_data_get_vertex(brain_data_cell{k});
    F  = surf_data_get_face(brain_data_cell{k});
    xx = surf_data_get_normal_vector(brain_data_cell{k});

    Vall{k} = V;
    Fall{k} = F;
end

% processing
[F_new, V_new, xx_new] = vb_combine_surf(Fall, Vall, [1:length(Fall)]);

% create new data
new_brain_data = surf_data_new(V_new, F_new, xx_new, ...
                                const.COORDINATE_ANALYZE_RIGHT_MM);
