function [obj, result] = ...
        bm_process_parm_list_set_parameter(obj, parm_type, parm)
% set parameter to brain_process_param_list
% [USAGE]
%    [obj, result] = ...
%        bm_process_parm_list_set_parameter(<obj>, <parm_type>, <parm>);
%
% [IN]
%          obj : bm_process_parm_list object
%    parm_type : parameter type to be set.
%         parm : parameter structure.
% [OUT]
%    obj : bm_process_parm_list object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end

%
% --- Main Procedure
%
result = SUCCESS;

const = define_bm_edit_app;
type = const.parm_type;

switch(parm_type)
    case type.SURF_SMOOTH_PARM
        [obj.surf_smooth_parameter, result] = ...
            bm_process_parm_set_parameter(obj.surf_smooth_parameter, parm);
    case type.SURF_SMOOTH_EXPAND_PARM
        [obj.surf_smooth_expand_parameter, result] = ...
            bm_process_parm_set_parameter(obj.surf_smooth_expand_parameter, parm);
    case type.SURF_TO_FILLED_MASK_PARM
        [obj.surf_to_filled_mask_parameter, result] = ...
            bm_process_parm_set_parameter(obj.surf_to_filled_mask_parameter, parm);
    case type.SEPARATE_SURF_PARM
        [obj.separate_surf_parameter, result] = ...
            bm_process_parm_set_parameter(obj.separate_surf_parameter, parm);
    case type.COMBINE_SURF_PARM
        [obj.combine_surf_parameter, result] = ...
            bm_process_parm_set_parameter(obj.combine_surf_parameter, parm);
    case type.CLOSE_SURF_PARM
        [obj.close_surf_parameter, result] = ...
            bm_process_parm_set_parameter(obj.close_surf_parameter, parm);
    case type.MORPHOLOGY_OPERATION_PARM
        [obj.morphology_operation_parameter, result] = ...
            bm_process_parm_set_parameter(obj.morphology_operation_parameter, parm);
    case type.SURF_EXTRACT_PARM
        [obj.surf_extract_parameter, result] = ...
            bm_process_parm_set_parameter(obj.surf_extract_parameter, parm);
end

%
% --- After check
%
if nargout ~= 2
    error('function caller should receive obj and result');
end
